import sys
import xbmc
import xbmcgui
import xbmcplugin
from urllib.parse import parse_qsl, urlencode

# Základní informace o addon
ADDON_HANDLE = int(sys.argv[1])
BASE_URL = sys.argv[0]

# Streamy
STREAMS = {
    "Noe Plus": "https://n105.quickmedia.tv/noe-2-abr/noe-2-abr/noe-2/Shz3_1_1/chunks_dvr.m3u8?n",
    "Noe": "https://n105.quickmedia.tv/noe-abr/noe-abr/noe/Ifd4_1_4/chunks_dvr.m3u8?nimbles"
}

def build_url(query):
    """Vytvoří URL pro navigaci v addonu."""
    return BASE_URL + "?" + urlencode(query)

def list_videos():
    """Zobrazí seznam dostupných streamů."""
    for name, url in STREAMS.items():
        stream_url = build_url({'action': 'play', 'video': url})
        li = xbmcgui.ListItem(label=name)
        li.setInfo('video', {'title': name, 'genre': 'Live TV'})
        li.setArt({'thumb': 'icon.png', 'icon': 'icon.png', 'fanart': 'icon.png'})
        li.setProperty('IsPlayable', 'true')
        xbmcplugin.addDirectoryItem(handle=ADDON_HANDLE, url=stream_url, listitem=li, isFolder=False)
    xbmcplugin.endOfDirectory(ADDON_HANDLE)

def play_video(path):
    """Přehraje video."""
    play_item = xbmcgui.ListItem(path=path)
    xbmcplugin.setResolvedUrl(ADDON_HANDLE, True, listitem=play_item)

def router(paramstring):
    """Směrování požadavků v addonu."""
    params = dict(parse_qsl(paramstring))
    if params:
        if params['action'] == 'play':
            play_video(params['video'])
    else:
        list_videos()

if __name__ == '__main__':
    router(sys.argv[2][1:])
